/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente.compras.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModeloValoresProveedor
implements ModeloValores {
    private boolean inicializado;
    private final Map<String, ElementoNombreValor<String>> tiposIdentificacion = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> tiposProveedor = new LinkedHashMap<String, ElementoNombreValor<String>>();

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarTiposIdentificacion();
            this.cargarTiposProveedor();
            this.inicializado = true;
        }
    }

    private void cargarTiposIdentificacion() {
        this.tiposIdentificacion.clear();
        this.tiposIdentificacion.put("R", (ElementoNombreValor<String>)new ElementoNombreValor("RUC", (Object)"R"));
        this.tiposIdentificacion.put("C", (ElementoNombreValor<String>)new ElementoNombreValor("CEDULA", (Object)"C"));
        this.tiposIdentificacion.put("P", (ElementoNombreValor<String>)new ElementoNombreValor("PASAPORTE/IDENTIFICACION TRIBUTARIA DEL EXTERIOR", (Object)"P"));
    }

    private void cargarTiposProveedor() {
        this.tiposProveedor.clear();
        this.tiposProveedor.put("01", (ElementoNombreValor<String>)new ElementoNombreValor("PERSONA NATURAL", (Object)"01"));
        this.tiposProveedor.put("02", (ElementoNombreValor<String>)new ElementoNombreValor("SOCIEDAD", (Object)"02"));
    }

    public List<ElementoNombreValor<String>> getTiposIdentificacion() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposIdentificacion.values());
    }

    public ElementoNombreValor<String> obtenerTipoIdentificacion(String tipoIdentificacion) {
        return StringUtil.isNullOrEmpty((String)tipoIdentificacion) ? null : this.tiposIdentificacion.get(tipoIdentificacion);
    }

    public List<ElementoNombreValor<String>> getTiposProveedor() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposProveedor.values());
    }

    public ElementoNombreValor<String> obtenerTipoProveedor(String tipoProveedor) {
        return StringUtil.isNullOrEmpty((String)tipoProveedor) ? null : this.tiposProveedor.get(tipoProveedor);
    }
}

